IF NOT EXISTS(SELECT TOP 1 1 FROM INFORMATION_SCHEMA.TABLES WHERE
						TABLE_NAME='EST_PROD_AGENDA_COMPRA_REALIZADO')
BEGIN
	SET ANSI_NULLS ON
	SET QUOTED_IDENTIFIER ON

	CREATE TABLE EST_PROD_AGENDA_COMPRA_REALIZADO(
		[ID]		[INT] IDENTITY (1,1) NOT NULL,
		[CD_CTR_AGENDA] [INT] NOT NULL CONSTRAINT [DF_EST_PROD_AGENDA_COMPRA_REALIZADO_CD_CTR_AGENDA]  DEFAULT ((0)),
		[DT_AGENDA]		[DATETIME] NOT NULL,
		[DT_REALIZADO]		[DATETIME] NOT NULL,
		[CD_USU]		[INT] NOT NULL CONSTRAINT [DF_EST_PROD_AGENDA_COMPRA_REALIZADO_CD_USU]  DEFAULT ((0)),
	 CONSTRAINT [PK_EST_PROD_AGENDA_COMPRA_REALIZADO] PRIMARY KEY CLUSTERED 
	(	[ID] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, 
				ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE EST_PROD_AGENDA_COMPRA_REALIZADO  WITH CHECK 
		ADD  CONSTRAINT [FK_EST_PROD_AGENDA_COMPRA_REALIZADO_EST_PROD_AGENDA_COMPRA] 
		FOREIGN KEY([CD_CTR_AGENDA]) 
			REFERENCES [EST_PROD_AGENDA_COMPRA] ([CD_CTR_AGENDA]) 
	
	ALTER TABLE EST_PROD_AGENDA_COMPRA_REALIZADO 
		CHECK CONSTRAINT [FK_EST_PROD_AGENDA_COMPRA_REALIZADO_EST_PROD_AGENDA_COMPRA]
END
  